//
//  MultiSelectTableViewController.m
//  MultiSelect
//
//  Created by Shin on 11/12/13.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "MultiSelectTableViewController.h"
#import "MultiSelectTableViewCell.h"

const NSInteger CELL_INDICATOR_TAG = 1234;
const NSInteger CELL_LABEL_TAG = 1235;
const NSInteger ALERT_DEL_TAG = 2345;

@implementation MultiSelectTableViewController

// 初期化
- (id)init {
    if ([super init] != nil) {
        const NSInteger NUM_ROWS = 20;
        
        arrayOfRows = [[NSMutableArray alloc] init];
        for (NSInteger i = 0; i < NUM_ROWS; i++) {
            NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
                                 [NSString stringWithFormat:@"アイテム %ld", i], @"name",
                                 [NSNumber numberWithBool:NO], @"checked",
                                 nil];
            [arrayOfRows addObject:dic];
        }
    }
    return self;
}

// メモリ解放
-(void)dealloc {
    [myTableView release];
    if (arrayOfRows) {
        [arrayOfRows release];
    }
    [super dealloc];
}


/*
 * テーブル処理
 */

// すべてのセルを編集可能
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
	return YES;
}

// セクション数
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	return 1;
}

// セル数
- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [arrayOfRows count];
}

// セル選択時の動作
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	if (tableView.isEditing) {
		UITableViewCell *cell = [myTableView cellForRowAtIndexPath:indexPath];		
		if (!cell) {
			return;
		}
		
		UIImageView *indicator = (UIImageView *)[cell.contentView viewWithTag:CELL_INDICATOR_TAG];

        NSMutableDictionary *dic = [arrayOfRows objectAtIndex:indexPath.row];
        BOOL status = [[dic objectForKey:@"checked"] boolValue];
		if (status) {
            NSDictionary *ndic = [NSDictionary dictionaryWithObjectsAndKeys:
                                 [dic objectForKey:@"name"], @"name",
                                 [NSNumber numberWithBool:NO], @"checked",
                                 nil];
            [arrayOfRows replaceObjectAtIndex:indexPath.row withObject:ndic];
			indicator.image = [UIImage imageNamed:@"btn_none.png"];
		} else {
            NSDictionary *ndic = [NSDictionary dictionaryWithObjectsAndKeys:
                                  [dic objectForKey:@"name"], @"name",
                                  [NSNumber numberWithBool:YES], @"checked",
                                  nil];
            [arrayOfRows replaceObjectAtIndex:indexPath.row withObject:ndic];
			indicator.image = [UIImage imageNamed:@"btn_checked.png"];
		}
        NSInteger counter = 0;
        for (NSDictionary *cdic in arrayOfRows) {
            BOOL status = [[cdic objectForKey:@"checked"] boolValue];
            if (status) {
                counter++;
            }
        }
        if (counter) {
            delButton.enabled = YES;
        } else {
            delButton.enabled = NO;
        }
	}
}

// セルの描画
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell* cell = nil;
    static NSString *myCellIdentifier = @"MultiSelectCellController";

    UIImageView *indicator;
	UILabel *textLabel;

    cell = [tableView dequeueReusableCellWithIdentifier:myCellIdentifier];
    if (cell == nil){
        cell = [[[MultiSelectTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                 reuseIdentifier:myCellIdentifier] autorelease];

        indicator = [[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"NotSelected.png"]] autorelease];
		const NSInteger IMAGE_SIZE   = 24;
		const NSInteger SIDE_PADDING = 5;
		
		indicator.tag   = CELL_INDICATOR_TAG;
		indicator.frame =
            CGRectMake(-EDITING_HORIZONTAL_OFFSET + SIDE_PADDING, (0.5 * tableView.rowHeight) - (0.5 * IMAGE_SIZE), IMAGE_SIZE, IMAGE_SIZE);
        [cell.contentView addSubview:indicator];
        
        textLabel = [[[UILabel alloc] initWithFrame:CGRectMake(SIDE_PADDING, 0, 320, tableView.rowHeight)] autorelease];
		textLabel.tag             = CELL_LABEL_TAG;
		textLabel.textColor       = [UIColor blackColor];
		textLabel.backgroundColor = [UIColor clearColor];
		textLabel.font            = [UIFont boldSystemFontOfSize:[UIFont labelFontSize]];
		[cell.contentView addSubview:textLabel];
        
		cell.selectionStyle = UITableViewCellSelectionStyleNone;
		cell.backgroundView = [[[UIView alloc] init] autorelease];
    } else {
		indicator = (UIImageView *)[cell.contentView viewWithTag:CELL_INDICATOR_TAG];
		textLabel = (UILabel *)[cell.contentView viewWithTag:CELL_LABEL_TAG];
	}

    NSDictionary *dic = [arrayOfRows objectAtIndex:indexPath.row];
    textLabel.text    = [dic objectForKey:@"name"];
    if (tableView.isEditing) {
        BOOL status = [[dic objectForKey:@"checked"] boolValue];
        if (status) {
            indicator.image = [UIImage imageNamed:@"btn_checked.png"];
        } else {
            indicator.image = [UIImage imageNamed:@"btn_none.png"];
        }
    }

    return cell;
}


/*
 * アクション
 */

// 編集モード有効
- (void)edit:(id)sender {
	[self.navigationController setToolbarHidden:NO animated:YES];
	
    UIBarButtonItem *cancelButton = [[[UIBarButtonItem alloc] initWithTitle:@"キャンセル"
                                                                      style:UIBarButtonItemStylePlain target:self
                                                                     action:@selector(cancel:)] autorelease];
    [self.navigationItem setRightBarButtonItem:cancelButton animated:NO];
	
	[myTableView setEditing:YES animated:YES];
}

// 編集モード無効
- (void)cancel:(id)sender {
    [self.navigationController setToolbarHidden:YES animated:YES];

    UIBarButtonItem *editButton = [[[UIBarButtonItem alloc] initWithTitle:@"編集"
                                                                    style:UIBarButtonItemStylePlain target:self
                                                                   action:@selector(edit:)] autorelease];
    [self.navigationItem setRightBarButtonItem:editButton animated:NO];
    
	[myTableView setEditing:NO animated:YES];
}

// 削除
- (void)delAction:(id)sender {
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"削除" message:@"削除してもよろしいですか？"
                                                   delegate:self
                                          cancelButtonTitle:@"キャンセル" otherButtonTitles:@"削除", nil];
    [alert setTag:ALERT_DEL_TAG];
    [alert show];
    [alert release];
}

// アラートボタン
-(void)alertView:(UIAlertView*)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (alertView.tag == ALERT_DEL_TAG) {
        NSString *buttonTitle = [alertView buttonTitleAtIndex:buttonIndex];
        if ([buttonTitle isEqualToString:@"削除"]) {
            NSLog(@"削除ボタンが押されたよ！");
        }
    }    
}


/*
 * 描画
 */

// ロード時に呼ばれる
- (void)viewDidLoad {
    [super viewDidLoad];

    UIBarButtonItem *editButton = [[[UIBarButtonItem alloc] initWithTitle:@"編集"
                                                                    style:UIBarButtonItemStylePlain target:self
                                                                   action:@selector(edit:)] autorelease];
	[self.navigationItem setRightBarButtonItem:editButton animated:NO];

    // TabeleViewの張り付け
    myTableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
    myTableView.dataSource = self;
    myTableView.delegate = self;
    myTableView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    myTableView.allowsSelectionDuringEditing = YES;
    [self.view addSubview:myTableView];

    // Toolbar
    self.navigationController.toolbar.tintColor = [UIColor blackColor];
    // スペーサー
    UIBarButtonItem *spacer = [[[UIBarButtonItem alloc]
                               initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                               target:nil action:nil] autorelease];
    // 削除ボタン
	delButton = [[[UIBarButtonItem alloc] initWithTitle:@"削除" style:UIBarButtonItemStyleBordered
                                                 target:self action:@selector(delAction:)] autorelease];
    if ([delButton respondsToSelector:@selector(setTintColor:)]){
        [delButton performSelector:@selector(setTintColor:) withObject:[UIColor colorWithRed:0.7 green:0.0 blue:0.0 alpha:1.0]];
    }
    delButton.enabled = NO;
    // 追加
    NSArray *items =
    [NSArray arrayWithObjects:spacer, delButton, spacer, nil];
    self.toolbarItems = items;
}

// アンロード時に呼ばれる
- (void)viewDidUnload {
    [super viewDidUnload];
    myTableView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
