//
//  MultiSelectTableViewCell.m
//  MultiSelect
//
//  Created by Shin on 11/12/13.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "MultiSelectTableViewCell.h"

const NSInteger EDITING_HORIZONTAL_OFFSET = 33;

@implementation MultiSelectTableViewCell

// 編集モード有効／無効時のレイアウトの初期化
- (void)setEditing:(BOOL)editing animated:(BOOL)animated {
	[self setNeedsLayout];
}

// 編集モード時のインジケーターの表示領域を設ける
- (void)layoutSubviews {
	[UIView beginAnimations:nil context:nil];
	[UIView setAnimationBeginsFromCurrentState:YES];

	[super layoutSubviews];

	if (((UITableView *)self.superview).isEditing) {
		CGRect contentFrame    = self.contentView.frame;
		contentFrame.origin.x  = EDITING_HORIZONTAL_OFFSET;
		self.contentView.frame = contentFrame;
	} else {
		CGRect contentFrame    = self.contentView.frame;
		contentFrame.origin.x  = 0;
		self.contentView.frame = contentFrame;
	}

	[UIView commitAnimations];
}

@end
