//
//  AppDelegate.m
//  MultiSelect
//
//  Created by Shin on 11/12/13.
//  Copyright (c) 2011 __MyCompanyName__. All rights reserved.
//

#import "AppDelegate.h"
#import "MultiSelectTableViewController.h"

@implementation AppDelegate

@synthesize window = _window;
@synthesize navigationController = _navigationController;

// メモリの解放
- (void)dealloc {
	[_navigationController release];
	[_window release];
	[super dealloc];
}

// 起動時に呼ばれる
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // ウィンドウの生成
    _window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    _window.backgroundColor = [UIColor whiteColor];
    [_window makeKeyAndVisible];
    
    //ビューコントローラの生成
    CGRect bounds = [[UIScreen mainScreen] bounds];
    UIViewController *ViewController = [[[MultiSelectTableViewController alloc] init] autorelease];
    [ViewController.view setFrame:bounds];
    
    //ナビゲーションコントローラの生成と追加
    _navigationController = [[UINavigationController alloc] init];
    [_navigationController pushViewController:ViewController animated:NO];
    [_window addSubview:_navigationController.view];

    _navigationController.navigationBar.tintColor = [UIColor colorWithRed:0.11 green:0.11 blue:0.11 alpha:1.0];
    _navigationController.toolbar.tintColor = [UIColor colorWithRed:0.11 green:0.11 blue:0.11 alpha:1.0];
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end
